<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

include 'config.php'; // Include database connection

$email = $_SESSION['user'];
$first_name = $_POST['first_name'];
$last_name = $_POST['last_name'];
$nickname = $_POST['nickname'];

// Handle profile image upload
if (isset($_FILES['profile_image']) && $_FILES['profile_image']['error'] == 0) {
    $target_dir = "uploads/";
    $target_file = $target_dir . basename($_FILES["profile_image"]["name"]);
    move_uploaded_file($_FILES["profile_image"]["tmp_name"], $target_file);
    $profile_image = $target_file;
} else {
    // Keep existing image if no new one is uploaded
    $stmt = $conn->prepare("SELECT profile_image FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $profile_image = $row['profile_image'];
    $stmt->close();
}

// Update user information in the database
$stmt = $conn->prepare("UPDATE users SET first_name = ?, last_name = ?, nickname = ?, profile_image = ? WHERE email = ?");
$stmt->bind_param("sssss", $first_name, $last_name, $nickname, $profile_image, $email);
$stmt->execute();
$stmt->close();

// Redirect back to dashboard
header("Location: dashboard.php");
exit();
?>