<?php
session_start();
include 'config.php'; // Ensure this defines $conn (database connection)

// Include PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

require '/home/svenrdhk/public_html/PHPMailer-master/src/Exception.php';
require '/home/svenrdhk/public_html/PHPMailer-master/src/PHPMailer.php';
require '/home/svenrdhk/public_html/PHPMailer-master/src/SMTP.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = filter_var($_POST['email'] ?? '', FILTER_SANITIZE_EMAIL);

    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        // Check if email exists in the database
        $stmt = $conn->prepare('SELECT id FROM users WHERE email = ?');
        if (!$stmt) {
            error_log('Database prepare error: ' . $conn->error);
            die('Internal server error. Please try again later.');
        }
        $stmt->bind_param('s', $email);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();

        // Generic success message to prevent email enumeration
        $success_message = "If this email exists, a recovery link will be sent. <a href='index.php'>Back to Login</a>";

        if ($user) {
            try {
                // Generate a unique reset token
                $token = bin2hex(random_bytes(32));
                $expires = date('Y-m-d H:i:s', strtotime('+1 hour'));

                // Insert or update the reset token in the database
                $stmt = $conn->prepare('INSERT INTO password_resets (email, token, expires_at) VALUES (?, ?, ?) 
                                        ON DUPLICATE KEY UPDATE token = ?, expires_at = ?');
                if (!$stmt) {
                    error_log('Database prepare error: ' . $conn->error);
                    die('Internal server error. Please try again later.');
                }
                $stmt->bind_param('sssss', $email, $token, $expires, $token, $expires);
                $stmt->execute();
                $stmt->close();

                // Set up PHPMailer
                $mail = new PHPMailer(true);
                $mail->isSMTP();
                $mail->Host = 'sveniverse.com';
                $mail->SMTPAuth = true;
                $mail->Username = 'no-reply@sveniverse.com';
                $mail->Password = 'BfHrixGJFnmu'; // Replace with your actual password
                $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // SSL for port 465
                $mail->Port = 465;

                // Set email details
                $mail->setFrom('no-reply@sveniverse.com', 'Sveniverse Support');
                $mail->addAddress($email);
                $mail->Subject = 'Password Reset Request';
                $mail->Body = "Hi,\r\n\r\n"
                            . "We received a password reset request for your account.\r\n\r\n"
                            . "Click the link below to reset your password:\r\n\r\n"
                            . "https://sveniverse.com/reset_password.php?token=" . urlencode($token) . "\r\n\r\n"
                            . "This link will expire in 1 hour.\r\n\r\n"
                            . "If you did not request this, please ignore this email.";

                // Send the email
                if ($mail->send()) {
                    echo $success_message;
                } else {
                    error_log('PHPMailer error: ' . $mail->ErrorInfo);
                    echo $success_message; // Avoid revealing email failure
                }
            } catch (Exception $e) {
                error_log('Error: ' . $e->getMessage());
                echo $success_message;
            }
        } else {
            echo $success_message;
        }
    } else {
        echo "Invalid email address. <a href='recover.php'>Try again</a>";
    }
} else {
    header("Location: recover.php");
    exit;
}
?>