<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

include 'config.php'; // Include database connection

$email = $_SESSION['user'];
$stmt = $conn->prepare("SELECT first_name, last_name, nickname, profile_image FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $first_name = $row['first_name'];
    $last_name = $row['last_name'];
    $nickname = $row['nickname'];
    $profile_image = $row['profile_image'] ?: 'default_profile.jpg'; // Fallback image
} else {
    $first_name = '';
    $last_name = '';
    $nickname = '';
    $profile_image = 'default_profile.jpg';
}
$stmt->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <style>
        body {
            <?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

include 'config.php'; // Include database connection

$email = $_SESSION['user'];
$stmt = $conn->prepare("SELECT first_name, last_name, nickname, profile_image FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $first_name = $row['first_name'];
    $last_name = $row['last_name'];
    $nickname = $row['nickname'];
    $profile_image = $row['profile_image'] ?: 'default_profile.jpg'; // Fallback image
} else {
    $first_name = '';
    $last_name = '';
    $nickname = '';
    $profile_image = 'default_profile.jpg';
}
$stmt->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/tailwindcss/2.2.19/tailwind.min.css" rel="stylesheet">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #008080;
        }
        aside {
            position: fixed;
            top: 1rem;
            left: 0.5rem;
            height: calc(100vh - 2rem);
            width: 4rem;
            background-color: white;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 9999px;
            padding: 1rem 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto;
        }
        aside a {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 50%;
            transition: background-color 0.3s;
        }
        main {
            margin-left: 4rem;
            padding: 1rem;
        }
        @media (min-width: 640px) {
            aside {
                width: 6rem;
            }
            main {
                margin-left: 6rem;
            }
        }
        .pill-input {
            border-radius: 9999px;
        }
        .blue-gradient-button {
            background: linear-gradient(to right, #3b82f6, #10b981);
            border-radius: 9999px;
        }
        .blue-gradient-button:hover {
            background: linear-gradient(to right, #2563eb, #059669);
        }
    </style>
</head>
<body class="flex flex-col min-h-screen">
    <!-- Sidebar -->
    <aside class="flex flex-col items-center">
        <img src="<?php echo htmlspecialchars($profile_image); ?>" alt="Profile" class="w-10 h-10 rounded-full mb-4">
        <div class="space-y-6">
            <a href="#home" class="text-gray-600 p-2 rounded hover:bg-blue-100"><i class="fas fa-home text-2xl"></i></a>
            <a href="#trophy" class="text-gray-600 p-2 rounded hover:bg-yellow-100"><i class="fas fa-trophy text-2xl"></i></a>
            <a href="#profile" class="text-gray-600 p-2 rounded hover:bg-green-100"><i class="fas fa-user text-2xl"></i></a>
            <a href="#plus" class="text-gray-600 p-2 rounded hover:bg-pink-100"><i class="fas fa-plus text-2xl"></i></a>
            <a href="#search" class="text-gray-600 p-2 rounded hover:bg-purple-100"><i class="fas fa-search text-2xl"></i></a>
            <a href="#calendar" class="text-gray-600 p-2 rounded hover:bg-teal-100"><i class="fas fa-calendar text-2xl"></i></a>
        </div>
        <div class="mt-auto space-y-6">
            <a href="#settings" class="text-gray-600 p-2 rounded hover:bg-gray-100"><i class="fas fa-cog text-2xl"></i></a>
            <a href="logout.php" class="text-gray-600 p-2 rounded hover:bg-red-100"><i class="fas fa-sign-out-alt text-2xl"></i></a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-grow p-4 pt-12 ml-16 sm:ml-24">
        <div class="bg-white p-8 rounded-lg shadow-md max-w-4xl w-full mx-auto">
            <h2 class="text-3xl font-bold mb-6 text-center">Update Profile</h2>
            <form action="update_profile.php" method="post" enctype="multipart/form-data">
                <div class="mb-4">
                    <label for="first_name" class="block text-gray-700 text-sm font-bold mb-2">First Name</label>
                    <input type="text" id="first_name" name="first_name" value="<?php echo htmlspecialchars($first_name); ?>" class="pill-input shadow appearance-none border w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                </div>
                <div class="mb-4">
                    <label for="last_name" class="block text-gray-700 text-sm font-bold mb-2">Last Name</label>
                    <input type="text" id="last_name" name="last_name" value="<?php echo htmlspecialchars($last_name); ?>" class="pill-input shadow appearance-none border w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                </div>
                <div class="mb-4">
                    <label for="nickname" class="block text-gray-700 text-sm font-bold mb-2">Nickname</label>
                    <input type="text" id="nickname" name="nickname" value="<?php echo htmlspecialchars($nickname); ?>" class="pill-input shadow appearance-none border w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                </div>
                <div class="mb-6">
                    <label for="profile_image" class="block text-gray-700 text-sm font-bold mb-2">Profile Image</label>
                    <input type="file" id="profile_image" name="profile_image" class="pill-input shadow appearance-none border w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline">
                    <p class="text-sm text-gray-500 mt-1">Current: <img src="<?php echo htmlspecialchars($profile_image); ?>" alt="Current Profile" class="inline h-8 w-8 rounded-full"></p>
                </div>
                <div class="flex items-center justify-center">
                    <button class="blue-gradient-button text-white font-bold py-2 px-4 w-full focus:outline-none focus:shadow-outline" type="submit">
                        Update Profile
                    </button>
                </div>
            </form>
        </div>
    </main>
</body>
</html>