<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

include 'config.php'; // Include database connection

$email = $_SESSION['user'];
$stmt = $conn->prepare("SELECT profile_image, gems, coins FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $profile_image = $row['profile_image'] ?: 'default_profile.jpg';
    $gems = $row['gems'] ?: 144; // Fallback to hardcoded value if not in DB
    $coins = $row['coins'] ?: 2321; // Fallback to hardcoded value if not in DB
} else {
    $profile_image = 'default_profile.jpg';
    $gems = 144;
    $coins = 2321;
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Math - Sveniverse</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f4f8;
        }
        aside {
            position: fixed;
            top: 1rem;
            left: 0.5rem;
            height: calc(100vh - 2rem);
            width: 4rem;
            background-color: white;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 9999px;
            padding: 1rem 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto;
            z-index: 10;
        }
        aside a {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 50%;
            transition: background-color 0.3s;
        }
        main {
            margin-left: 4rem;
            padding: 1rem;
        }
        #iframe-container {
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            z-index: 20;
            background-color: white;
        }
        #topic-iframe {
            width: 100%;
            height: calc(100% - 2rem); /* Adjust for the back link height */
        }
        @media (min-width: 640px) {
            aside {
                width: 6rem;
            }
            main {
                margin-left: 6rem;
            }
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">
    <?php include 'sidebar.php'; ?>

    <main class="flex-grow p-4 pt-12">
        <?php include 'topbar.php'; ?>

        <div id="topics-grid" class="bg-teal-100 shadow-md p-4">
            <h2 class="text-2xl font-bold text-gray-800 mb-4">Math Topics</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-4">
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="loadTopic('multiplication-fun.html')">
                    <h3 class="text-lg font-bold text-gray-800">Roll the Dice</h3>
                    <p class="text-gray-600">Multiplication</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="loadTopic('math-arithmetic.html')">
                    <h3 class="text-lg font-bold text-gray-800">Arithmetic</h3>
                    <p class="text-gray-600">Basic Skills</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="loadTopic('placeholder.html')">
                    <h3 class="text-lg font-bold text-gray-800">Calculus</h3>
                    <p class="text-gray-600">Limits and derivatives</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="loadTopic('placeholder.html')">
                    <h3 class="text-lg font-bold text-gray-800">Statistics</h3>
                    <p class="text-gray-600">Data and probability</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="loadTopic('placeholder.html')">
                    <h3 class="text-lg font-bold text-gray-800">Trigonometry</h3>
                    <p class="text-gray-600">Angles and functions</p>
                </div>
            </div>
        </div>
        <div id="iframe-container" class="hidden flex flex-col">
            <a href="#" id="back-to-topics" class="p-2">
                <i class="fas fa-arrow-left text-blue-500 text-2xl"></i>
            </a>
            <iframe id="topic-iframe" frameborder="0"></iframe>
        </div>
    </main>

    <div id="modal" class="fixed inset-0 bg-gray-600 bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white p-8 rounded-lg shadow-lg max-w-lg w-full">
            <h2 class="text-2xl font-bold mb-4">Topic Details</h2>
            <div id="modal-content"></div>
            <button id="close-modal" class="mt-4 bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">Close</button>
        </div>
    </div>

    <footer class="bg-white p-4 text-center text-gray-600">
        <p>© 2025 SveniverseAtom. All rights reserved.</p>
    </footer>

    <script>
        function loadTopic(url) {
            document.getElementById('topics-grid').classList.add('hidden');
            document.getElementById('iframe-container').classList.remove('hidden');
            document.getElementById('topic-iframe').src = url;
        }

        document.addEventListener('DOMContentLoaded', function() {
            const searchIcon = document.querySelector('a[href="#search"]');
            const searchBar = document.getElementById('search-bar');
            if (searchIcon && searchBar) {
                searchIcon.addEventListener('click', function(event) {
                    event.preventDefault();
                    searchBar.classList.toggle('hidden');
                });
            }

            document.getElementById('close-modal').addEventListener('click', function() {
                document.getElementById('modal').classList.add('hidden');
                document.getElementById('modal-content').innerHTML = '';
            });

            document.getElementById('back-to-topics').addEventListener('click', function(event) {
                event.preventDefault();
                document.getElementById('iframe-container').classList.add('hidden');
                document.getElementById('topics-grid').classList.remove('hidden');
            });
        });

        function showModal(data) {
            const modalContent = document.getElementById('modal-content');
            if (data.type === 'text') {
                modalContent.innerHTML = `<p class="text-gray-600">${data.content}</p>`;
            } else if (data.type === 'html') {
                modalContent.innerHTML = `<iframe src="${data.content}" class="w-full h-64" frameborder="0"></iframe>`;
            }
            document.getElementById('modal').classList.remove('hidden');
        }
    </script>
</body>
</html>