<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

include 'config.php'; // Include database connection

$email = $_SESSION['user'];
$stmt = $conn->prepare("SELECT profile_image, gems, coins FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $profile_image = $row['profile_image'] ?: 'default_profile.jpg';
    $gems = $row['gems'] ?: 144; // Fallback to hardcoded value if not in DB
    $coins = $row['coins'] ?: 2321; // Fallback to hardcoded value if not in DB
} else {
    $profile_image = 'default_profile.jpg';
    $gems = 144;
    $coins = 2321;
}
$stmt->close();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Math - Sveniverse</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f4f8;
        }
        aside {
            position: fixed;
            top: 1rem;
            left: 0.5rem;
            height: calc(100vh - 2rem);
            width: 4rem;
            background-color: white;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 9999px;
            padding: 1rem 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto;
        }
        aside a {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 50%;
            transition: background-color 0.3s;
        }
        main {
            margin-left: 4rem;
            padding: 1rem;
        }
        @media (min-width: 640px) {
            aside {
                width: 6rem;
            }
            main {
                margin-left: 6rem;
            }
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">
    <?php include 'sidebar.php'; ?>

    <main class="flex-grow p-4 pt-12">
        <?php include 'topbar.php'; ?>

        <div class="bg-teal-100 shadow-md p-4">
            <h2 class="text-2xl font-bold text-gray-800 mb-4">Math Topics</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-5 gap-4">
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="showModal('Details about Algebra: Explore equations, variables, and functions.')">
                    <h3 class="text-lg font-bold text-gray-800">Algebra</h3>
                    <p class="text-gray-600">Equations and variables</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="showModal('Details about Geometry: Study shapes, angles, and spatial properties.')">
                    <h3 class="text-lg font-bold text-gray-800">Geometry</h3>
                    <p class="text-gray-600">Shapes and properties</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="showModal('Details about Calculus: Learn limits, derivatives, and integrals.')">
                    <h3 class="text-lg font-bold text-gray-800">Calculus</h3>
                    <p class="text-gray-600">Limits and derivatives</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="showModal('Details about Statistics: Analyze data, probability, and trends.')">
                    <h3 class="text-lg font-bold text-gray-800">Statistics</h3>
                    <p class="text-gray-600">Data and probability</p>
                </div>
                <div class="bg-white p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300" onclick="showModal('Details about Trigonometry: Understand angles and trigonometric functions.')">
                    <h3 class="text-lg font-bold text-gray-800">Trigonometry</h3>
                    <p class="text-gray-600">Angles and functions</p>
                </div>
            </div>
        </div>
    </main>

    <div id="modal" class="fixed inset-0 bg-gray-600 bg-opacity-50 flex items-center justify-center hidden">
        <div class="bg-white p-8 rounded-lg shadow-lg max-w-lg w-full">
            <h2 class="text-2xl font-bold mb-4">Topic Details</h2>
            <p id="modal-content" class="text-gray-600"></p>
            <button id="close-modal" class="mt-4 bg-blue-500 text-white px-4 py-2 rounded hover:bg-blue-600">Close</button>
        </div>
    </div>

    <footer class="bg-white p-4 text-center text-gray-600">
        <p>© 2025 SveniverseAtom. All rights reserved.</p>
    </footer>

    <script>
        function showModal(content) {
            document.getElementById('modal-content').innerText = content;
            document.getElementById('modal').classList.remove('hidden');
        }

        document.addEventListener('DOMContentLoaded', function() {
            const searchIcon = document.querySelector('a[href="#search"]');
            const searchBar = document.getElementById('search-bar');
            searchIcon.addEventListener('click', function(event) {
                event.preventDefault();
                searchBar.classList.toggle('hidden');
            });

            document.getElementById('close-modal').addEventListener('click', function() {
                document.getElementById('modal').classList.add('hidden');
            });
        });
    </script>
</body>
</html>