<?php
session_start();
include 'config.php';

$email = $_POST['email'];
$password = $_POST['password'];

// Prepare the SELECT query to fetch id and password
$stmt = $conn->prepare("SELECT id, password,user_type FROM users WHERE email = ? AND user_type = 'parent'");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    if (password_verify($password, $row['password'])) {
        $_SESSION['user'] = $email;
        
        // Update last_login with the current timestamp
        $update_stmt = $conn->prepare("UPDATE users SET last_login = NOW() WHERE id = ?");
        $update_stmt->bind_param("i", $row['id']);
        $update_stmt->execute();
        $update_stmt->close();
        
        header("Location: dashboard.php");
        exit();
    } else {
        echo "Invalid password. <a href='index.php'>Try again</a>";
    }
} else {
    echo "No user found with that email. <a href='index.php'>Try again</a>";
}

$stmt->close();
$conn->close();
?>