<?php
session_start();
if (isset($_SESSION['user'])) {
    header("Location: dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #008080;
        }
    </style>
</head>
<body class="flex items-center justify-center min-h-screen px-4">
    <div class="bg-white p-4 sm:p-8 rounded-lg shadow-md max-w-4xl w-full flex flex-col sm:flex-row">
        <div class="w-full sm:w-1/2 mb-4 sm:mb-0">
            <img src="37576617_8518727.jpg" alt="Login Illustration" class="w-full h-48 sm:h-full object-cover rounded-lg sm:rounded-l-lg sm:rounded-r-none">
        </div>
        <div class="w-full sm:w-1/2 p-4 sm:p-8">
            <!-- Login Form -->
            <div id="login-form">
                <?php if (isset($_GET['signup']) && $_GET['signup'] == 'success'): ?>
                    <p class="text-green-500 bg-green-100 p-2 rounded text-center mb-4">Registration successful! Please log in.</p>
                <?php endif; ?>
                <form action="login.php" method="post">
                    <h2 class="text-2xl sm:text-3xl font-bold mb-6 text-center">Login</h2>
                    <div class="mb-4 relative">
                        <label for="email" class="block text-gray-700 text-sm font-bold mb-2">Email</label>
                        <div class="relative">
                            <input type="email" id="email" name="email" class="shadow appearance-none border rounded-full w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline pl-10" placeholder="randy.h99@email.com" required>
                            <i class="fas fa-envelope absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                        </div>
                    </div>
                    <div class="mb-6 relative">
                        <label for="password" class="block text-gray-700 text-sm font-bold mb-2">Password</label>
                        <div class="relative">
                            <input type="password" id="password" name="password" class="shadow appearance-none border rounded-full w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline pr-10" placeholder="••••••••" required>
                            <i class="fas fa-eye absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 cursor-pointer" id="togglePassword"></i>
                        </div>
                    </div>
                    <p class="text-right mb-4"><a href="#" id="forgot-password" class="text-orange-500 hover:text-orange-700">Forgot Password?</a></p>
                    <div class="flex items-center justify-center mb-6">
                        <button class="bg-gradient-to-r from-blue-500 to-green-500 hover:from-blue-600 hover:to-green-600 text-white font-bold py-2 px-4 rounded-full focus:outline-none focus:shadow-outline w-full" type="submit">
                            Log In
                        </button>
                    </div>
                </form>
                <p class="text-center">Don't have an account? <a href="#" id="show-register" class="text-blue-500 hover:text-blue-700">Sign up</a></p>
            </div>
            <!-- Recovery Form -->
            <div id="recovery-form" class="hidden">
                <form action="recover.php" method="post">
                    <h2 class="text-2xl sm:text-3xl font-bold mb-8 text-center">Recover Password</h2>
                    <div class="mb-8 relative">
                        <label for="recovery-email" class="block text-gray-700 text-sm font-bold mb-2">Email</label>
                        <div class="relative">
                            <input type="email" id="recovery-email" name="email" class="shadow appearance-none border rounded-full w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline pl-10" placeholder="randy.h99@email.com" required>
                            <i class="fas fa-envelope absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                        </div>
                    </div>
                    <div class="flex items-center justify-center mb-4">
                        <button class="bg-gradient-to-r from-blue-500 to-green-500 hover:from-blue-600 hover:to-green-600 text-white font-bold py-2 px-4 rounded-full focus:outline-none focus:shadow-outline w-full" type="submit">
                            Send Password
                        </button>
                    </div>
                </form>
                <p class="text-center"><a href="#" id="back-to-login" class="text-blue-500 hover:text-blue-700">Back to Login</a></p>
            </div>
            <!-- Register Form -->
            <div id="register-form" class="hidden">
                <form id="registerForm" action="register.php" method="post">
                    <h2 class="text-2xl sm:text-3xl font-bold mb-6 text-center">Sign Up</h2>
                    <div class="mb-4 relative">
                        <label for="register-email" class="block text-gray-700 text-sm font-bold mb-2">Email</label>
                        <div class="relative">
                            <input type="email" id="register-email" name="email" class="shadow appearance-none border rounded-full w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline pl-10" placeholder="randy.h99@email.com" required>
                            <i class="fas fa-envelope absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                        </div>
                    </div>
                    <div class="mb-4 relative">
                        <label for="register-password" class="block text-gray-700 text-sm font-bold mb-2">Password</label>
                        <div class="relative">
                            <input type="password" id="register-password" name="password" class="shadow appearance-none border rounded-full w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline pr-10" placeholder="••••••••" required>
                            <i class="fas fa-eye absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 cursor-pointer" id="toggleRegisterPassword"></i>
                        </div>
                    </div>
                    <div class="mb-6 relative">
                        <label for="confirm-password" class="block text-gray-700 text-sm font-bold mb-2">Confirm Password</label>
                        <div class="relative">
                            <input type="password" id="confirm-password" name="confirm-password" class="shadow appearance-none border rounded-full w-full py-2 px-3 text-gray-700 leading-tight focus:outline-none focus:shadow-outline pr-10" placeholder="••••••••" required>
                            <i class="fas fa-eye absolute right-3 top-1/2 transform -translate-y-1/2 text-gray-400 cursor-pointer" id="toggleConfirmPassword"></i>
                        </div>
                    </div>
                    <div class="flex items-center justify-center mb-4">
                        <button class="bg-gradient-to-r from-blue-500 to-green-500 hover:from-blue-600 hover:to-green-600 text-white font-bold py-2 px-4 rounded-full focus:outline-none focus:shadow-outline w-full" type="submit">
                            Sign Up
                        </button>
                    </div>
                </form>
                <p class="text-center"><a href="#" id="back-to-login-from-register" class="text-blue-500 hover:text-blue-700">Back to Login</a></p>
            </div>
        </div>
    </div>
    <script>
        const togglePassword = document.getElementById('togglePassword');
        const passwordInput = document.getElementById('password');
        const forgotPasswordLink = document.getElementById('forgot-password');
        const backToLoginLink = document.getElementById('back-to-login');
        const loginForm = document.getElementById('login-form');
        const recoveryForm = document.getElementById('recovery-form');
        const registerForm = document.getElementById('register-form');
        const showRegisterLink = document.getElementById('show-register');
        const backToLoginFromRegister = document.getElementById('back-to-login-from-register');
        const toggleRegisterPassword = document.getElementById('toggleRegisterPassword');
        const registerPasswordInput = document.getElementById('register-password');
        const toggleConfirmPassword = document.getElementById('toggleConfirmPassword');
        const confirmPasswordInput = document.getElementById('confirm-password');

        function showForm(formToShow) {
            loginForm.classList.add('hidden');
            recoveryForm.classList.add('hidden');
            registerForm.classList.add('hidden');
            formToShow.classList.remove('hidden');
        }

        togglePassword.addEventListener('click', function () {
            const type = passwordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            passwordInput.setAttribute('type', type);
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash');
        });

        toggleRegisterPassword.addEventListener('click', function () {
            const type = registerPasswordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            registerPasswordInput.setAttribute('type', type);
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash');
        });

        toggleConfirmPassword.addEventListener('click', function () {
            const type = confirmPasswordInput.getAttribute('type') === 'password' ? 'text' : 'password';
            confirmPasswordInput.setAttribute('type', type);
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash');
        });

        forgotPasswordLink.addEventListener('click', function (e) {
            e.preventDefault();
            showForm(recoveryForm);
        });

        backToLoginLink.addEventListener('click', function (e) {
            e.preventDefault();
            showForm(loginForm);
        });

        showRegisterLink.addEventListener('click', function (e) {
            e.preventDefault();
            showForm(registerForm);
        });

        backToLoginFromRegister.addEventListener('click', function (e) {
            e.preventDefault();
            showForm(loginForm);
        });
    </script>
</body>
</html>