<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

include 'config.php'; // Include database connection

$email = $_SESSION['user'];
$stmt = $conn->prepare("SELECT first_name, nickname, gems, coins FROM users WHERE email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $first_name = $row['first_name'];
    $nickname = $row['nickname'];
    $gems = $row['gems'];
    $coins = $row['coins'];
} else {
    $first_name = '';
    $nickname = '';
    $gems = 0;
    $coins = 0;
}
$stmt->close();

// Fetch top 10 users for leaderboard
$leaderboard_stmt = $conn->prepare("
    SELECT first_name, nickname, email, points, profile_image 
    FROM users 
    ORDER BY points DESC 
    LIMIT 10
");
$leaderboard_stmt->execute();
$leaderboard_result = $leaderboard_stmt->get_result();
$leaderboard_users = $leaderboard_result->fetch_all(MYSQLI_ASSOC);
$leaderboard_stmt->close();

if (!empty($first_name)) {
    $welcome_message = "Hello, $first_name!";
} elseif (!empty($nickname)) {
    $welcome_message = "Hello, $nickname!";
} else {
    $welcome_message = "Hello, $email!";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sveniverse Dashboard</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f4f8;
        }
        aside {
            position: fixed;
            top: 1rem;
            left: 0.5rem;
            height: calc(100vh - 2rem);
            width: 4rem;
            background-color: white;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 9999px;
            padding: 1rem 0;
            display: flex;
            flex-direction: column;
            align-items: center;
            overflow-y: auto;
        }
        aside a {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 50%;
            transition: background-color 0.3s;
        }
        .profile-image {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 50%;
            background: linear-gradient(135deg, #3498db, #2ecc71);
        }
        main {
            margin-left: 4rem;
            padding: 1rem;
        }
        @media (min-width: 640px) {
            aside {
                width: 6rem;
            }
            main {
                margin-left: 6rem;
            }
        }
        .welcome-message {
            position: relative;
            left: -100%;
        }
    </style>
</head>
<body class="min-h-screen flex flex-col">
    <!-- Sidebar -->
    <aside class="flex flex-col items-center">
        <div class="profile-image"></div>
        <div class="mt-4 space-y-6">
            <a href="#home" class="text-gray-600 p-2 rounded hover:bg-blue-100"><i class="fas fa-home text-2xl"></i></a>
            <a href="#trophy" class="text-gray-600 p-2 rounded hover:bg-yellow-100"><i class="fas fa-trophy text-2xl"></i></a>
            <a href="#profile" class="text-gray-600 p-2 rounded hover:bg-green-100"><i class="fas fa-user text-2xl"></i></a>
            <a href="#plus" class="text-gray-600 p-2 rounded hover:bg-pink-100"><i class="fas fa-plus text-2xl"></i></a>
            <a href="#search" class="text-gray-600 p-2 rounded hover:bg-purple-100"><i class="fas fa-search text-2xl"></i></a>
            <a href="#calendar" class="text-gray-600 p-2 rounded hover:bg-teal-100"><i class="fas fa-calendar text-2xl"></i></a>
        </div>
        <div class="mt-auto space-y-6">
            <a href="#settings" class="text-gray-600 p-2 rounded hover:bg-gray-100"><i class="fas fa-cog text-2xl"></i></a>
            <a href="logout.php" class="text-gray-600 p-2 rounded hover:bg-red-100"><i class="fas fa-sign-out-alt text-2xl"></i></a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-grow p-4 pt-12">
        <div class="fixed top-4 right-4 flex space-x-4">
            <p class="welcome-message text-lg font-bold text-blue-800"><?php echo $welcome_message; ?></p>
            <div id="search-bar" class="hidden bg-white p-2 rounded-full shadow-md">
                <input type="text" placeholder="Search..." class="outline-none">
            </div>
            <div class="bg-blue-100 text-blue-800 px-4 py-2 rounded-full flex items-center space-x-2">
                <i class="fas fa-gem"></i><span><?php echo $gems; ?></span>
                <i class="fas fa-coins"></i><span><?php echo $coins; ?></span>
            </div>
            <div class="bg-red-100 text-red-500 p-2 rounded-full">
                <i class="fas fa-bell"></i>
            </div>
        </div>

        <div class="bg-teal-100 shadow-md p-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div class="md:col-span-3 space-y-6">
                    <div class="grid grid-cols-1 sm:grid-cols-3 gap-4 mb-6">
                        <div class="bg-blue-50 p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300">
                            <h3 class="text-lg font-bold text-blue-800">Completed</h3>
                            <p class="text-3xl font-semibold text-blue-600">56%</p>
                            <i class="fas fa-chart-pie text-blue-500 text-4xl float-right"></i>
                        </div>
                        <div class="bg-purple-50 p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300">
                            <h3 class="text-lg font-bold text-purple-800">Lessons</h3>
                            <p class="text-3xl font-semibold text-purple-600">21/23</p>
                            <i class="fas fa-book text-purple-500 text-4xl float-right"></i>
                        </div>
                        <div class="bg-pink-50 p-4 rounded-lg shadow hover:shadow-lg transform hover:scale-105 transition duration-300">
                            <h3 class="text-lg font-bold text-pink-800">Hours</h3>
                            <p class="text-3xl font-semibold text-pink-600">120/111</p>
                            <i class="fas fa-clock text-pink-500 text-4xl float-right"></i>
                        </div>
                    </div>

                    <div class="mb-6">
                        <div class="flex justify-between items-center mb-4">
                            <h2 class="text-xl font-bold text-gray-800">Select Category <span class="text-gray-500">(7)</span></h2>
                            <i class="fas fa-search-plus text-gray-600 text-xl"></i>
                        </div>
                        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-7 gap-4">
                            <a href="science.php" class="block hover:shadow-lg">
                                <div class="bg-green-100 p-2 rounded-lg shadow text-center">
                                    <i class="fas fa-flask text-green-500 text-2xl mb-1"></i>
                                    <h3 class="text-base font-bold text-green-800">Science</h3>
                                </div>
                            </a>
                            <a href="math.php" class="block hover:shadow-lg">
                                <div class="bg-blue-100 p-2 rounded-lg shadow text-center">
                                    <i class="fas fa-calculator text-blue-500 text-2xl mb-1"></i>
                                    <h3 class="text-base font-bold text-blue-800">Math</h3>
                                </div>
                            </a>
                            <a href="technology.php" class="block hover:shadow-lg">
                                <div class="bg-purple-100 p-2 rounded-lg shadow text-center">
                                    <i class="fas fa-laptop text-purple-500 text-2xl mb-1"></i>
                                    <h3 class="text-base font-bold text-purple-800">Technology</h3>
                                </div>
                            </a>
                            <a href="finance.php" class="block hover:shadow-lg">
                                <div class="bg-yellow-100 p-2 rounded-lg shadow text-center">
                                    <i class="fas fa-dollar-sign text-yellow-500 text-2xl mb-1"></i>
                                    <h3 class="text-base font-bold text-yellow-800">Finance</h3>
                                </div>
                            </a>
                            <a href="language.php" class="block hover:shadow-lg">
                                <div class="bg-red-100 p-2 rounded-lg shadow text-center">
                                    <i class="fas fa-language text-red-500 text-2xl mb-1"></i>
                                    <h3 class="text-base font-bold text-red-800">Language</h3>
                                </div>
                            </a>
                            <a href="art.php" class="block hover:shadow-lg">
                                <div class="bg-pink-100 p-2 rounded-lg shadow text-center">
                                    <i class="fas fa-palette text-pink-500 text-2xl mb-1"></i>
                                    <h3 class="text-base font-bold text-pink-800">Art</h3>
                                </div>
                            </a>
                            <a href="lifeskills.php" class="block hover:shadow-lg">
                                <div class="bg-teal-100 p-2 rounded-lg shadow text-center">
                                    <i class="fas fa-lightbulb text-teal-500 text-2xl mb-1"></i>
                                    <h3 class="text-base font-bold text-teal-800">Life Skills</h3>
                                </div>
                            </a>
                        </div>
                    </div>

                    <div class="bg-white p-4 rounded-lg shadow mb-6 flex items-center">
                        <img src="https://via.placeholder.com/100x100" alt="Robot Character" class="w-24 h-24 rounded-full mr-4">
                        <div>
                            <h3 class="text-xl font-bold text-gray-800">Mind Unlocked</h3>
                            <p class="text-gray-600">The Human Mind: A Deep Dive into Thoughts, Emotions, and Behavior</p>
                            <div class="flex items-center space-x-2 text-sm text-gray-600">
                                <i class="fas fa-gem"></i><span>+5</span>
                                <i class="fas fa-coins"></i><span>+145</span>
                                <i class="fas fa-fire text-red-500"></i>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white p-4 rounded-lg shadow mb-6">
                        <div class="flex justify-between items-center mb-4">
                            <h2 class="text-xl font-bold text-gray-800">Study Success</h2>
                            <button class="bg-blue-100 text-blue-800 px-3 py-1 rounded-full text-sm">Learn more</button>
                        </div>
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-gray-600">Today's Revenue</p>
                                <p class="text-2xl font-bold text-gray-800">+2.3% 78%</p>
                            </div>
                            <img src="https://via.placeholder.com/200x100" alt="Graph" class="w-48 h-24">
                        </div>
                    </div>

                    <div class="mb-6">
                        <div class="flex justify-between items-center mb-4">
                            <h2 class="text-xl font-bold text-gray-800">Badges <span class="text-gray-500">(8)</span></h2>
                            <a href="#" class="text-blue-500 hover:text-blue-700">View all</a>
                        </div>
                        <div class="grid grid-cols-3 gap-4">
                            <div class="bg-white p-4 rounded-lg shadow text-center">
                                <i class="fas fa-book text-blue-500 text-3xl mb-2"></i>
                                <p class="text-sm font-semibold">Reader</p>
                            </div>
                            <div class="bg-white p-4 rounded-lg shadow text-center">
                                <i class="fas fa-heart text-red-500 text-3xl mb-2"></i>
                                <p class="text-sm font-semibold">Lover</p>
                            </div>
                            <div class="bg-white p-4 rounded-lg shadow text-center">
                                <i class="fas fa-book-open text-green-500 text-3xl mb-2"></i>
                                <p class="text-sm font-semibold">Scholar</p>
                            </div>
                        </div>
                    </div>

                    <div class="mb-6">
                        <div class="flex justify-between items-center mb-4">
                            <h2 class="text-xl font-bold text-gray-800">Challenges <span class="text-gray-500">(12)</span></h2>
                            <a href="#" class="text-blue-500 hover:text-blue-700">View all</a>
                        </div>
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
                            <div class="bg-purple-100 p-4 rounded-lg shadow transition duration-300 hover:scale-105 hover:shadow-lg">
                                <i class="fas fa-graduation-cap text-purple-500 text-3xl mb-2"></i>
                                <h3 class="text-lg font-bold text-purple-800">Deep Focus</h3>
                                <p class="text-sm text-gray-600">Extra challenge</p>
                                <div class="flex items-center space-x-2 text-sm text-gray-600">
                                    <i class="fas fa-gem"></i><span>+250</span>
                                </div>
                            </div>
                            <div class="bg-yellow-100 p-4 rounded-lg shadow transition duration-300 hover:scale-105 hover:shadow-lg">
                                <i class="fas fa-trophy text-yellow-500 text-3xl mb-2"></i>
                                <h3 class="text-lg font-bold text-yellow-800">Daily Challenge</h3>
                                <p class="text-sm text-gray-600">Day 10/32</p>
                                <div class="flex items-center space-x-2 text-sm text-gray-600">
                                    <i class="fas fa-gem"></i><span>+5</span>
                                    <i class="fas fa-coins"></i><span>+200</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="md:col-span-1">
                    <div class="bg-white p-4 rounded-lg shadow">
                        <h2 class="text-xl font-bold text-gray-800 mb-4">Leaderboard</h2>
                        <canvas id="leaderboard-chart" class="w-full h-64"></canvas>
                        <table class="w-full text-left text-sm text-gray-600 mt-4">
                            <thead>
                                <tr>
                                    <th>Pos</th>
                                    <th>Profile</th>
                                    <th>Name</th>
                                    <th>Points</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($leaderboard_users as $index => $user): ?>
                                    <tr>
                                        <td><?php echo $index + 1; ?></td>
                                        <td>
                                            <?php if (!empty($user['profile_image'])): ?>
                                                <img src="<?php echo $user['profile_image']; ?>" alt="Profile" class="w-8 h-8 rounded-full">
                                            <?php else: ?>
                                                <div class="w-8 h-8 rounded-full bg-gray-300"></div>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php
                                            if (!empty($user['first_name'])) {
                                                echo $user['first_name'];
                                            } elseif (!empty($user['nickname'])) {
                                                echo $user['nickname'];
                                            } else {
                                                $email_parts = explode('@', $user['email']);
                                                $masked_email = substr($email_parts[0], 0, 1) . str_repeat('*', strlen($email_parts[0]) - 1) . '@' . $email_parts[1];
                                                echo $masked_email;
                                            }
                                            ?>
                                        </td>
                                        <td><?php echo $user['points']; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <footer class="bg-white p-4 text-center text-gray-600">
        <p>© 2025 SveniverseAtom. All rights reserved.</p>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchIcon = document.querySelector('a[href="#search"]');
            const searchBar = document.getElementById('search-bar');
            searchIcon.addEventListener('click', function(event) {
                event.preventDefault();
                searchBar.classList.toggle('hidden');
            });

            const welcomeMessage = document.querySelector('.welcome-message');
            let position = -100;
            function slideIn() {
                if (position < 0) {
                    position += 5;
                    welcomeMessage.style.left = position + '%';
                    requestAnimationFrame(slideIn);
                } else {
                    welcomeMessage.style.left = '0';
                }
            }
            requestAnimationFrame(slideIn);
        });

        const ctx = document.getElementById('leaderboard-chart').getContext('2d');
        const chart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['Jack Nicklson', 'Timothy Bell', 'Brody Bellson'],
                datasets: [{
                    label: 'Points',
                    data: [65322, 21780, 21780],
                    backgroundColor: ['#FFD700', '#C0C0C0', '#CD7F32'],
                    borderColor: ['#FFD700', '#C0C0C0', '#CD7F32'],
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    legend: {
                        display: false
                    }
                }
            }
        });
    </script>
</body>
</html>